<?php

namespace Src\Domain\Shared;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Tag extends Model 
{

    protected $table = 'tags';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'type', 'color');
    protected $visible = array('id');
    protected $hidden = array('timestamps');

    public function tagable()
    {
        return $this->morphTo();
    }

}